require( "quest/mg_triangle/convout.lua" );
combine_speech_tables();

round_num = 
{
	1, -- round one
};

local activity_complete = false;

local triangle =
{
	yellow = { colour = "yellow", imageUp = "triangle_yellow_up", imageDown = "triangle_yellow_down" };
	red = { colour = "red", imageUp = "triangle_red_up", imageDown = "triangle_red_down" };
	blue = { colour = "blue", imageUp = "triangle_blue_up", imageDown = "triangle_blue_down" };
	purple = { colour = "purple", imageUp = "triangle_purple_up", imageDown = "triangle_purple_down" };
};

local lockStatusIndicator = 
{
	lockedImage = "box_lid";
	unlockedImage = "";
};

local lockStatusIndicatorItem = nil;

local puzzleElements = { }; -- this table is just for keeping track of elements that should be deleted when the box is opened
local triangles = { };

-- triangle rotation "animation" stuff
local triRot = { };
local triRotItem = { };
local triRotPos = { };
local triPivot = nil;
local triRotator = nil;
local triRotatorPos = { };
local CurrentlyRotatingTriangle = false;
local rotateSpeed = 2.0;

-- hexagon rotation "animation" stuff
local hexRot = { };
local hexRotItem = { };
local hexRotPos = { };
local hexPivot = nil;
local CurrentlyRotatingHexagon = false;

local triangleCentreOffsetDown = { x = 31.5, y = 18.5 };
local triangleCentreOffsetUp = { x = 31, y = 35 };

local rotator1 = { image = "rotator1", overimage = "rotator1_rollover", offset = { x = 14, y = 20 }, offsetUp = { x = 0, y = 22 }, offsetDown = { x = 0, y = -16 } };
local rotator2 = { image = "rotator2", overimage = "rotator2_rollover", offset = { x = 20, y = 20 }, offsetUp = { x = 0, y = 21 }, offsetDown = { x = 0, y = -16 } };

local lock =
{
	-- large triangle positions relative to the lock (6 per lock) (also used for spawning triangle rotators)
	lockTrianglePositions = 
	{
		{ x = 0, y = -58 }, { x = 65, y = -58 }, { x = 65, y = 58 }, { x = 0, y = 58 }, { x = -65, y = 58 }, { x = -65, y = -58 }
	};
	-- triangle positions relative to each large triangle (3 per large trignale)
	-- triangles with one vertex above two
	triangleUpPositions = 
	{
		{ x = 0, y = -22 }, { x = -30, y = 30 }, { x = 30, y = 30 }
	};
	-- triangles with two vertices above one
	triangleDownPositions = 
	{
		{ x = -30, y = -26 }, { x = 30, y = -26 }, { x = 0, y = 26 }
	};
};

local screenLayout =
{
	correctComboOffset = { x = 207, y = 195 };
	lockStatusIndicator = { x = 0, y = 0 },
	startComboOffset = { x = 531, y = 195 }
};

-- combinations
local items = 
{
	-- level_one = 
	{
		correctCombo = 
		{ 
			"red", "red", "blue", 
			 "red", "blue", "red",
			"yellow", "purple", "purple",
			"yellow", "purple", "purple",
			"purple", "yellow", "purple",
			"red", "red", "blue"
		};
		startCombo = 
		{ 
			"purple", "yellow", "red", 
			 "purple", "red", "blue",
			"red", "purple", "purple",
			"red", "blue", "purple",
			"yellow", "red", "blue",
			"purple", "yellow", "red"
		};
	};
};


-- permute images of each triangle in specified largeTriangle
function RotateTriangle1( index )	
	-- get the index into the triangle array of the first triangle (the other two triangles will be this index +1 and +2)
	local triangleIndex = ( ( index - 1 ) * 3 ) + 1;
	-- NOTE: Have to do it this way since no way of getting image string out of actor	
	triRot[1] = triangleIndex;
	-- orient triangle based on type (up or down)
	if ( IsDownTriangleLarge( index ) ) then
		triRot[2] = triangleIndex + 1;
		triRot[3] = triangleIndex + 2;
	else
		triRot[2] = triangleIndex + 2;
		triRot[3] = triangleIndex + 1;
	end	
	for i = 1, 3 do
		triRotItem[i] = triangles[triRot[i]].item;
		triRotPos[i] = triRotItem[i]:GetPosition();
		triRotItem[i]:SetDepthValue(10);
	end
	triPivot = { x = ( triRotPos[1].x + triRotPos[2].x + triRotPos[3].x ) / 3, y = ( triRotPos[1].y + triRotPos[2].y + triRotPos[3].y ) / 3 };
	if ( IsDownTriangleLarge( index ) ) then 
		triPivot = { x = triPivot.x + triangleCentreOffsetDown.x, y = triPivot.y + triangleCentreOffsetDown.y };
	else
		triPivot = { x = triPivot.x + triangleCentreOffsetUp.x, y = triPivot.y + triangleCentreOffsetUp.y };
	end
	CurrentlyRotatingTriangle = true;
end

function RotateTriangle3()
	-- correction
	for i = 1, 3 do
		triRotItem[i]:JumpToPoint( triRotPos[i] );
		triRotItem[i]:SetRadians( 0 );
		triRotItem[i]:SetDepthValue(2);
	end
	
	RotateTriangle2( triRotator.startAngle, triRotator, triRotatorPos, triPivot )
	
	-- do rotation	
	local temp = triangles[triRot[3]].images;
	for i = 1, 2 do		
		local rotIndex = 4 - i;
		triangles[triRot[rotIndex]].item.image = GetTriangleImage( triRot[rotIndex], triangles[triRot[rotIndex - 1]]["images"] )
		load_triangle_image( triangles[triRot[rotIndex]].item );
		triangles[triRot[rotIndex]].images = triangles[triRot[rotIndex - 1]].images;
	end
	triangles[triRot[1]].item.image = GetTriangleImage( triRot[1] , temp );
	load_triangle_image( triangles[triRot[1]].item );
	triangles[triRot[1]].images = temp;
	-- stuff from elsewhere that now has to go here
	triRot = { };
	triRotItem = { };
	triRotPos = { };
	triPivot = nil;
	if ( IsUnlocked() ) then
		scene.FLO:StartProc(activity_passed);
	end
end

function game_loop()
	local i = 0;
	while ( activity_complete == false ) do
		if ( CurrentlyRotatingTriangle == true ) then
			i = i + 3;
			RotateTriangle2( i, triRotItem[1], triRotPos[1], triPivot );
			RotateTriangle2( i, triRotItem[2], triRotPos[2], triPivot );
			RotateTriangle2( i, triRotItem[3], triRotPos[3], triPivot );
			RotateTriangle2( i+triRotator.startAngle, triRotator, triRotatorPos, triPivot );
			if ( (i*rotateSpeed) >= 120 ) then
				CurrentlyRotatingTriangle = false;				
				i = 0;				
				RotateTriangle3();
			end			
		end
		if ( CurrentlyRotatingHexagon == true ) then
			i = i + 3;
			RotateTriangle2( i, hexRotItem[1], hexRotPos[1], hexPivot );
			RotateTriangle2( i, hexRotItem[2], hexRotPos[2], hexPivot );
			RotateTriangle2( i, hexRotItem[3], hexRotPos[3], hexPivot );
			RotateTriangle2( i, hexRotItem[4], hexRotPos[4], hexPivot );
			RotateTriangle2( i, hexRotItem[5], hexRotPos[5], hexPivot );
			RotateTriangle2( i, hexRotItem[6], hexRotPos[6], hexPivot );
			if ( (i*rotateSpeed) >= 60 ) then
				CurrentlyRotatingHexagon = false;				
				i = 0;				
				RotateHexagon3();
			end			
		end
		delay(1);
	end	
end

function RotateTriangle2( i, tri, pos, pivot ) -- doubles as RotateHexagon2
	-- rotate by one degree (converted to radians)
	local angle = i * (0.017453292519943295769236907684886 * rotateSpeed);
	local nx = pivot.x + (pos.x - pivot.x) * math.cos(angle) - (pos.y - pivot.y) * math.sin(angle);
	local ny = pivot.y + (pos.x - pivot.x) * math.sin(angle) + (pos.y - pivot.y) * math.cos(angle);	
	tri:JumpToPoint( { x = nx, y = ny } );
	tri:SetRadians( angle );	
end

-- permute images of each triangle in the central hexagon and correct the image according to the new orientation (up or down)
function RotateHexagon1()
	-- NOTE: Have to do it this way since no way of getting image string out of actor	
	hexRot = { 3, 5, 7, 10, 14, 18 };
	
	for i = 1, 6 do
		hexRotItem[i] = triangles[hexRot[i]].item;
		hexRotPos[i] = hexRotItem[i]:GetPosition();		
	end
	hexPivot = { x = ( hexRotPos[1].x + hexRotPos[2].x + hexRotPos[3].x + hexRotPos[4].x + hexRotPos[5].x + hexRotPos[6].x ) / 6, y = ( hexRotPos[1].y + hexRotPos[2].y + hexRotPos[3].y + hexRotPos[4].y + hexRotPos[5].y + hexRotPos[6].y ) / 6 };
	hexPivot = { x = hexPivot.x + ( triangleCentreOffsetDown.x + triangleCentreOffsetUp.x ) / 2, y = hexPivot.y + ( triangleCentreOffsetDown.y + triangleCentreOffsetUp.y ) / 2 };
	CurrentlyRotatingHexagon = true;
end

function RotateHexagon3()	
	-- correction
	for i = 1, 6 do
		hexRotItem[i]:JumpToPoint( hexRotPos[i] );
		hexRotItem[i]:SetRadians( 0 );
	end

	-- do rotation
	local temp = triangles[hexRot[6]].images;
	for i = 1, 5 do		
		local index = 7 - i;
		triangles[hexRot[index]].item.image = GetTriangleImage( hexRot[index], triangles[hexRot[index - 1]]["images"] );
		load_triangle_image( triangles[hexRot[index]].item );
		triangles[hexRot[index]].images = triangles[hexRot[index - 1]].images;
	end
	triangles[hexRot[1]].item.image = GetTriangleImage( hexRot[1] , temp );
	load_triangle_image( triangles[hexRot[1]].item );
	triangles[hexRot[1]].images = temp;
	
	-- stuff from elsewhere that now has to go here
	hexRot = { };
	hexRotItem = { };
	hexRotPos = { };
	pivot = nil;
	if ( IsUnlocked() ) then
		--lockStatusIndicatorItem:LoadImage( lockStatusIndicator.unlockedImage );						
		scene.FLO:StartProc(activity_passed);
	end
end

function IsUnlocked()
	for i,v in pairs(items) do
		if i == game:Get("mg_trilock_activity_num") then			
			for j,w in pairs(v.correctCombo) do
				if ( w ~= triangles[j]["images"].colour ) then
					return false;
				end
			end
		end
	end
	return true;
end

function load_triangle_image(triangle)
	if triangle.over then
		triangle:LoadImage(triangle.image .. "_glow");
	else
		triangle:LoadImage(triangle.image);
	end
end

function get_trirotator_item_spec(_name, _image, _over_image, _index, _isMovable)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint (GetTriRotatorPosition( _index, _isMovable ));
			if not _isMovable then
				actor:SetPointAtCursor("cursor");
			end
			actor:SetAlpha( 1 );
			actor:SetDepthValue(5);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			if IsDownTriangleLarge( _index ) then
				actor.startAngle = 0;
			else
				actor.startAngle = 30;
			end
			
			-- setup initial rotation... a bit convoluted I know, but it works!
			RotateTriangle1( _index )
			CurrentlyRotatingTriangle = false;
			triRotator = actor;
			triRotatorPos = GetTriRotatorPosition( _index, true );
			RotateTriangle3();
			if _isMovable == false then
				local pos1 = GetTriRotatorPosition( _index, true );
				local pos2 = GetTriRotatorPosition( _index, false );
				move_actor_x(actor, -(pos1.x - pos2.x));
			end
			
			if ( _isMovable ) then
				actor.on_click = function(flo, item)
					if ( CurrentlyRotatingTriangle == false and CurrentlyRotatingHexagon == false ) then
						sfx:PlaySFX("audio/sfx/recipe_box_turn");
						triRotator = actor;
						triRotatorPos = GetTriRotatorPosition( _index, _isMovable );
						RotateTriangle1( _index );	
					end
				end;
				
				actor.point_at_fn = function(item, enter)
					local triangleIndex = ( ( _index - 1 ) * 3 ) + 1;
					if enter then
						item:LoadImage(_over_image);
						
						for i=0,2 do
							triangles[triangleIndex+i].item.over = true;
							load_triangle_image(triangles[triangleIndex+i].item);
						end
					else
						item:LoadImage(_image);
						for i=0,2 do
							triangles[triangleIndex+i].item.over = false;
							load_triangle_image(triangles[triangleIndex+i].item);
						end
					end
				end;
			else
				actor.on_click = function(flo, item)	
					return RESPONSE.IGNORE;			
				end;
			end
		end;
	}
end

function get_hexrotator_item_spec(_name, _image, _over_image, _isMovable)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint (GetHexRotatorPosition( _isMovable ));
			if not _isMovable then
				actor:SetPointAtCursor("cursor");
			end
			actor:SetAlpha( 1 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			if ( _isMovable ) then
				actor.on_click = function(flo, item)	
					if ( CurrentlyRotatingTriangle == false and CurrentlyRotatingHexagon == false ) then
						sfx:PlaySFX("audio/sfx/recipe_box_turn");
						RotateHexagon1();			
					end
				end;
				
				actor.point_at_fn = function(item, enter)
					hexRot = { 3, 5, 7, 10, 14, 18 };
					if enter then
						item:LoadImage(_over_image);
						
						for i=1,6 do
							triangles[hexRot[i]].item.over = true;
							load_triangle_image(triangles[hexRot[i]].item);
						end
					else
						item:LoadImage(_image);
						
						for i=1,6 do
							triangles[hexRot[i]].item.over = false;
							load_triangle_image(triangles[hexRot[i]].item);
						end
					end
				end;
			else
				actor.on_click = function(flo, item)	
					return RESPONSE.IGNORE;			
				end;
			end
		end;
	}
end

function get_triangle_item_spec(_name, _images, _index, _isMovable)
	return
	{
		name = _name;
		halo = "";
		gfx = { image = "" }; -- will LoadImage below
		
		command = function(actor)
			actor:JumpToPoint (GetTrianglePosition( _index, _isMovable ));
			actor.image = GetTriangleImage( _index, _images );
			actor.over = false;
			load_triangle_image( actor );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			actor:SetDepthValue( 2 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor.index = _index;
		end;
	}
end

function get_lockstatusindicator_item_spec(_name, _image)
	return
	{
		name = _name;
		halo = "";
		gfx = { image = _image };
		
		command = function(actor)
			actor:SetDepthValue( 1 );
			actor:JumpToPoint (GetLockStatusIndicatorPosition());
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );			
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
		end;
	}
end

function IsDownTriangleLarge( index )
	if ( fmod( index - 1, 2 ) == 0 ) then
		return true;
	end
	return false;
end

function IsDownTriangle( index )
	if ( fmod( index - 1, 6 ) <= 2 ) then
		return true;
	end
	return false;
end

function GetTrianglePosition(index, isMovable)
	local triangleIndex = math.floor( ( index - 1 ) / 3 ) + 1;
	local triangleMod = math.floor( fmod( index - 1, 3 ) ) + 1;
	local xPos = (lock["lockTrianglePositions"])[triangleIndex].x;
	local yPos = (lock["lockTrianglePositions"])[triangleIndex].y;
	if ( isMovable ) then
		xPos = screenLayout["startComboOffset"].x + xPos;
		yPos = screenLayout["startComboOffset"].y + yPos;
	else
		xPos = screenLayout["correctComboOffset"].x + xPos;
		yPos = screenLayout["correctComboOffset"].y + yPos;
	end		
	if ( IsDownTriangleLarge( triangleIndex ) ) then 
		xPos = xPos + lock["triangleDownPositions"][triangleMod].x;
		yPos = yPos + lock["triangleDownPositions"][triangleMod].y;
	else
		xPos = xPos + lock["triangleUpPositions"][triangleMod].x;
		yPos = yPos + lock["triangleUpPositions"][triangleMod].y;
	end	
	return { x = xPos, y = yPos };
end

function GetTriRotatorPosition( index, isMovable )
	local xPos = (lock["lockTrianglePositions"])[index].x + rotator1["offset"].x;
	local yPos = (lock["lockTrianglePositions"])[index].y + rotator1["offset"].x;
	if ( isMovable ) then
		xPos = screenLayout["startComboOffset"].x + xPos;
		yPos = screenLayout["startComboOffset"].y + yPos;
	else
		xPos = screenLayout["correctComboOffset"].x + xPos;
		yPos = screenLayout["correctComboOffset"].y + yPos;
	end	
	if ( IsDownTriangleLarge( index ) ) then 
		xPos = xPos + rotator1["offsetDown"].x;
		yPos = yPos + rotator1["offsetDown"].y;
	else
		xPos = xPos + rotator1["offsetUp"].x;
		yPos = yPos + rotator1["offsetUp"].y;
	end
	return { x = xPos, y = yPos };
end

function GetHexRotatorPosition( isMovable )
	local xPos = rotator2["offset"].x;
	local yPos = rotator2["offset"].x;
	if ( isMovable ) then
		xPos = screenLayout["startComboOffset"].x + xPos;
		yPos = screenLayout["startComboOffset"].y + yPos;
	else
		xPos = screenLayout["correctComboOffset"].x + xPos;
		yPos = screenLayout["correctComboOffset"].y + yPos;
	end	
	return { x = xPos, y = yPos };
end

function GetLockStatusIndicatorPosition()
	return screenLayout["lockStatusIndicator"];
end

function GetTriangleImage( index, images )
	if ( IsDownTriangle( index ) ) then 
		return images.imageDown;
	end
	return images.imageUp;
end

function spawn_trilock_combination(actor)
	for i,v in pairs(items) do
		if i == game:Get("mg_trilock_activity_num") then
			-- need to pass both possible images in since they may change during the puzzle
			for j,w in pairs(v.correctCombo) do
				local triangle_item_spec = get_triangle_item_spec("correct" .. tostring(j) .. tostring( game:Get("mg_trilock_activity_num") ), triangle[w], j, false);				
				table.insert(puzzleElements, scene:Spawn(triangle_item_spec));
			end
			for j,w in pairs(v.startCombo) do
				local triangle_item_spec = get_triangle_item_spec("start" .. tostring(j) .. tostring( game:Get("mg_trilock_activity_num") ), triangle[w], j, true);				
				table.insert( triangles, j, { item = scene:Spawn(triangle_item_spec), images = triangle[w] } );
				table.insert(puzzleElements, triangles[j].item);
			end
		end
	end
	-- spawn triangle rotators and hexagonal rotator (for each of correct and start locks)
	for j,w in pairs(lock.lockTrianglePositions) do
		local triRotator_item_spec = get_trirotator_item_spec("correctTriRotator" .. tostring(j) .. tostring( game:Get("mg_trilock_activity_num") ), rotator1.image, rotator1.overimage, j, false);
		table.insert(puzzleElements, scene:Spawn(triRotator_item_spec));
		triRotator_item_spec = get_trirotator_item_spec("startTriRotator" .. tostring(j) .. tostring( game:Get("mg_trilock_activity_num") ), rotator1.image, rotator1.overimage, j, true);
		table.insert(puzzleElements, scene:Spawn(triRotator_item_spec));
	end	
	local hexRotator_item_spec = get_hexrotator_item_spec("correctHexRotator" .. tostring( game:Get("mg_trilock_activity_num") ), rotator2.image, rotator2.overimage, false);
	table.insert(puzzleElements, scene:Spawn(hexRotator_item_spec));
	local hexRotator_item_spec = get_hexrotator_item_spec("startHexRotator" .. tostring( game:Get("mg_trilock_activity_num") ), rotator2.image, rotator2.overimage, true);
	table.insert(puzzleElements, scene:Spawn(hexRotator_item_spec));
	-- spawn lock status indicator
	local lockStatusIndicator_item_spec = get_lockstatusindicator_item_spec("lockStatusIndicator" .. tostring( game:Get("mg_trilock_activity_num") ), lockStatusIndicator.lockedImage);
	lockStatusIndicatorItem = scene:Spawn(lockStatusIndicator_item_spec);
end

function setup_activity()
	local activityNum = game:Get("mg_trilock_activity_num");
	local activityRound = game:Get("mg_trilock_activity_round");

	if activityNum == 1 and activityRound == 1 then
		help_panel_say_raw(scene:grabstring("tutorial_1"));
	else
		help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
	end
end;

function next_activity(flo)
	local activityNum = game:Get("mg_trilock_activity_num");
	local activityRound = game:Get("mg_trilock_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	
	if roundComplete then	
		game:Set("triangle_unlocked", 1);
		addInventory(inv_desc_recipe);
		scene.HELP_PANEL:SetAlpha(0);
		help_panel_say_raw("");
		game:Set("got_recipe", 1)
		goto_scene(flo, "m2_bakery");	
	else
		scene.NEXT_ACTIVITY_BUTTON:Expire();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
		end
		
		spawn_button(hint_button_spec);		
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		-- load new puzzle
		setup_activity();
	end
end;

function activity_passed(flo)
	scene.FLO:SetMode(MODE.CUTSCENE);
	activity_complete = true;
	local activityNum = game:Get("mg_trilock_activity_num");
	local activityRound = game:Get("mg_trilock_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	help_panel_say_raw(
		scene:grabstring("finished_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
	scene.HINT_BUTTON:Expire();
	scene.BACK_BUTTON:Expire();
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_pattern.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	coroutine.yield(RESUME.ON_CLICK);
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	sfx:PlaySFX("audio/sfx/recipe_box_open");
	lockStatusIndicatorItem:LoadImage( lockStatusIndicator.unlockedImage );
	clearPuzzle();
	
	scene:Spawn(recipe_paper_spec);
	
	--spawn_button(next_activity_button_spec);
end;

function clearPuzzle()
	for i,v in pairs(puzzleElements) do
		v:Expire();
	end
end

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m2_bakery");
end

recipe_paper_spec = 
{
	name = "RECIPE_PAPER";
	gfx = { image = "recipe_paper" };
	halo = "recipe_paper";
	
	command = function(actor)
		actor:SetDepthValue(20);
	end;
	
	on_click = function(flo, actor)
		game:Set("mg_trilock_activity_round", 2);
		game:Set("mg_trilock_activity_num", 1);
		
		game:Set("triangle_unlocked", 1);
		game:Set("got_recipe", 1)	
		
		flo:StartProc(go_back);
	end;
};

local hint_button_choice = 0;

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		if hint_button_choice == 1 then
			hint_button_choice = 2;
			help_panel_say_raw(scene:grabstring("hint_" .. hint_button_choice));
		else
			hint_button_choice = 1;
			help_panel_say_raw(scene:grabstring("hint_" .. hint_button_choice));
		end
		scene.HELP_PANEL:StartProc(resume_help_on_click);
	end;
}

function resume_help_on_click(help_panel)
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	help_panel_say_raw(scene:grabstring("tutorial_1"));
end


scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		game:ClearInvUsage();
		
		fade_scene_up(true);
		
		if IsCheatMode() then
			--testing
			if game:GetString("trilock_level") == "" then
				game:SetString("trilock_level", "level_one");
			end
			
			--game:Set("mg_trilock_activity_num", 0);
			--game:Set("mg_trilock_activity_round", 0);
			
			spawn_button(pass_activity_button_spec);
		end
		
		-- set up for initial play
		if game:Get("mg_trilock_activity_num") < 1 then
			game:Set("mg_trilock_activity_num", 1);
		end
		
		if game:Get("mg_trilock_activity_round") < 1 then
			game:Set("mg_trilock_activity_round", 1);
		end
		
		spawn_trilock_combination();	
		
		lower_hud();
		spawn_button(hint_button_spec);
		spawn_help_panel();
		
		setup_activity();
		
		game_loop();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		scene_setup,
	};
};
